import { world, ItemStack } from '@minecraft/server'

world.beforeEvents.worldInitialize.subscribe(eventData => {
    eventData.blockTypeRegistry.registerCustomComponent('v360:copper_lantern', {
        onPlayerInteract(e) {
            const { block, player } = e
            const equipment = player.getComponent('equippable')
            const selectedItem = equipment.getEquipment('Mainhand')
            if (selectedItem?.typeId === 'minecraft:water_bucket') {
                player.playSound('bucket.empty_water')
                if (player.getGameMode() !== "creative") {
                    equipment.setEquipment('Mainhand', new ItemStack('minecraft:bucket', 1));
                }
            }
            if (block.typeId === 'v360:copper_lantern' && selectedItem?.typeId === 'minecraft:water_bucket') {
                const blockFace = block.permutation.getState('minecraft:block_face')
                let structureName = '';
                if (blockFace === 'down') {
                    structureName = 'mystructure:hanging_copper_lantern'
                } else if (blockFace === 'up') {
                    structureName = 'mystructure:floor_copper_lantern'
                }
                if (structureName) {
                    const { x, y, z } = block
                    world.structureManager.place(structureName, e.dimension, { x, y, z })
                }
            }
        }
    })
})

world.beforeEvents.worldInitialize.subscribe(eventData => {
    eventData.blockTypeRegistry.registerCustomComponent('v360:unlit_lantern', {
        onPlayerInteract(e) {
            const { block, player } = e
            const equipment = player.getComponent('equippable')
            const selectedItem = equipment.getEquipment('Mainhand')
            if (selectedItem?.typeId === 'minecraft:water_bucket') {
                player.playSound('bucket.empty_water')
                if (player.getGameMode() !== "creative") {
                    equipment.setEquipment('Mainhand', new ItemStack('minecraft:bucket', 1));
                }
            }
            if (block.typeId === 'v360:unlit_lantern' && selectedItem?.typeId === 'minecraft:water_bucket') {
                const blockFace = block.permutation.getState('minecraft:block_face')
                let structureName = '';
                if (blockFace === 'down') {
                    structureName = 'mystructure:hanging_unlit_lantern'
                } else if (blockFace === 'up') {
                    structureName = 'mystructure:floor_unlit_lantern'
                }
                if (structureName) {
                    const { x, y, z } = block
                    world.structureManager.place(structureName, e.dimension, { x, y, z })
                }
            }
        }
    })
})